//								EJEMPLO 16
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El manejo de la pantalla LCD
//
//Este ejemplo pretende introducirnos en el manejo de la pantalla LCD, para la visualizacin
//de diferentes mensajes (p.e. Hola).

#include <16f876A.h>	

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)
#include <lcd2.c>	//Incluir funciones de manejo del LCD

main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);	//Puerta A Digital
	set_tris_a(0x3F);				//RA0-RA5 entradas
	set_tris_b(0x00);				//RB0-RB7 salidas	   

	while(1)
	{
    lcd_init();	// Comandos de inicializacin del LCD.

    lcd_enviar(LCD_COMANDO,LCD_CURSOR_BLINK); // Enva comando al LCD
    lcd_putc('H');  // Enva caracter al LCD.
    lcd_putc('o');
    lcd_putc('l');
    lcd_putc('a');
    lcd_putc(' ');
    sleep();
  }
}	
